# **ВНИМАНИЕ !**

Ansible являются средствами автоматизированной (не автоматической) настройки кластера, облегчающей запуск рутинных
команд на нескольких серверах. Перед первым запуском требуется изучить запускаемые на серверах задачи (tasks).
Для этого просмотрите содержимое директории roles/ и файлов плейбуков. При необходимости откорректируйте нужные файлы.
Запрещается продолжение работы с без выполнения требований данного абзаца.

## Общаяя информация по содержимому

- create-cl.yml сборка кластера из готовых нод с AxelNAC
- create-local-upgrade.sh создание docker-anac-update.tar
- upgrade-cl.yml обновление кластера из локального архива с обновлениями
- ansible.cfg локальна конфигурация
- multizone пример инвентарного файла для мультизоновог кластера
- normal пример инвентарного файла для обычного кластера
- files дополнительные файлы для плейбуков, например архив обновления docker-anac-update.tar
- templates шаблоны конфига для кластера и hosts для нод
- roles роль обновления
- encrypt.sh (пример) скрипт получения val.cry
- pass.sh (пример) скрипт генерации пароля для шифрования
- val.cry (пример) шифрованные данные для плейбука
- README.md это файл

## env

```bash
# export ANSIBLE_HOST_KEY_CHECKING=False
# export ANSIBLE_CONFIG=./ansible.cfg
```

## Запуск сборки кластера

## Подготовка

Пароли зашифрованы в плейбуке, если их нужно поменять, то
меняем в encrypt.sh и запускаем, получаем val.cry и данные из него переносим в плейбук
перед началом заполняем инвентарник cluster нужными параметрами и типом кластера
(обычный[normal] и мультизона[l3])

## Требования

На нодах, для построения кластера, должен быть пройден 1 шаг визарда с указанием интерфейса управления и установленной
отметкой "высокая доступность" , а на мастере визард проходим до конца. (можно везде пройти до конца) для использования,
требуется нода с установленным ansible (~200Mb) с доступом к узлам кластера или установка на любой узел кластера
(только обновление, т.к. ноды перезагружаются)!!!
Перед запуском ansible сделать export ANSIBLE_CONFIG=ansible.cfg и запускать плейбук из директории с конфигом

## ПРИМЕР - для обычного кластера (пример инвентарного файла - normal)

```ini
[cluster:children]
dc1

[dc1]
dc1-anac3-n1 ansible_host=10.31.205.87 vip=10.31.205.111 master=true
dc1-anac3-n2 ansible_host=10.31.205.119
dc1-anac3-n3 ansible_host=10.31.205.120
```

## ПРИМЕР - для multizone кластера (пример инвентарного файла - multizone)

```ini
[cluster:children]
dc1
dc2

[dc1]
dc1-anac5-n1 ansible_host=10.31.205.87 vip=10.31.205.111 master=true
dc1-anac5-n2 ansible_host=10.31.205.119
dc1-anac5-n3 ansible_host=10.31.205.120

[dc2]
dc2-anac5-n1 ansible_host=10.31.205.121 vip=10.31.205.112
dc2-anac5-n2 ansible_host=10.31.205.122
```

## ПРИМЕР - ОБЩИЕ ПАРАМЕТРЫ

```ini
[cluster:vars]
####### !!!!!!!!!!!! type = 'normal' or 'l3' !!!!!!!!!!! #######
type=l3

ansible_ssh_common_args='-o StrictHostKeyChecking=no -o PasswordAuthentication=yes'
ansible_user=root
ansible_ssh_pass=Y5upeAd9
#ansible_ssh_pass=123123
ansible_python_interpreter="/usr/bin/python3"
# mem >= 8 Gb
mem=7944
# cpu >= 4
cpu=4
# sda.size >= 200 Gb
hdd=100
```

## Для запуска плейбука нужно

- в файле инвентаризации cluster указать ip адреса нод в секциях master и nodes
- указать от имени какого пользователя производятся действия ansible_user=root, если 
  вход не от root, то применяем ключи -Kb (потребует ввода пароля root)
- его пароль ansible_ssh_pass=superpassword
- vip адрес кластера cluster_mng_ip=10.31.205.134
- в самом плейбуке поправить параметры проверки на соответствие

## Для запуска плейбука с двумя мастер нодами

- в файле инвентаризации cluster разкомментировать dc2
- указать ip адреса нод в секции nodes
- второй vip адрес кластера
- указать тип кластера type=l3

плейбук разбит на стадии тегами, по которым можно запускать/повторять отдельно серию задач этого шага при необходимости

[chec]
ansible_memtotal_mb.real | int >= 7944 (проверяется MEM >8Gb)
ansible_devices.sda.size[:-5] | int >= 100 (проверяется HDD > 100Gb)
db_service_status.status.ActiveState == 'active' (проверяется работает ли MariaDB)
при несоответствии работа плейбука прерывается

[init]
делает необходимые правки в sysctl
ставит недостающее ПО (пропустить, при недоступности репозитория)
правит hostname согласно invetary и обновляет записи /etc/hosts
создает пользователя реплики
перезапускает узлы
[galera1]
формирует конфиги кластера
перезапускает сервисы на мастере
[galera2]
переводим мастер в режим создания кластера
отключаем iptables
[galera3]
синхронизируем конфиги нод с мастером
[galera4]
качаем конфиги чтобы посмотреть локально что они одинаковы не обязательно, просто тест
[galera5]
рестартим сервисы на нодах
[galera6]
мастер возвращаем в обычный режим
включаем galera-autofix
[galera7]
рестарт сервисов на нодах
рестарт сервисов на мастере
ребут узлов
некоторые шаги игнорируют ошибки, при запуске плейбука он не остановится и это обычно
не критично для сборки кластера (надо понимать чем вызван сбой)

## примеры запуска

```bash
 ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml
```

или если нужно выполнить 1 шаг

```bash
ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml -t init
```

или на конкретном хосте

```bash
 ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml -t init -l hostname
```

или несколько шагов

```bash
 ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml -t galera1,galera2,galera3,galera4,galera5,galera6,galera7
```

## Запуск ообновления кластера

Требования:

- перед обновлением нужно сформироать архив обновления docker-anac-update.tar и сделать ссылку на него в files/
- в файле roles/files/local-upgrade.sh установить или закомментировать
  export LOCAL_INSTALL='yes' - для установки из локального репозитория
  export DB_UPDATE='yes' - если требуется обновить DB

## пример запуска

```bash
ANSIBLE_CONFIG=./ansible.cfg ansible-playbook -i normal --vault-id ./pass.sh upgrade-cl.yml -vv
```

## Подсказки по ansible

Все ноды должны быть доступны, проверить можно командой

```bash
 ansible -i normal all --vault-id ./pass.sh -m ping
```

Если нужно ограничиться группой или хостом, то указываем вместо all
путь к логфайлу можно задать так - export ANSIBLE_LOG_PATH=~/ansible.log
и включить дебаг # export ANSIBLE_DEBUG=True
или перенаправить

```bash
 time ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml 2>&1 > log
```

Запускать команды на удаленных ВМ можно так

```bash
 ansible -i normal all --vault-id ./pass.sh -m shell -a "/ANAC/bin/pfcmd service pf restart"
```

инфа о хосте

```bash
 ansible -i normal all -m ansible.builtin.gather_facts --tree
```

или

```bash
 ansible -b -i normal all -m gather_facts
```

или

```bash
 ansible -i normal all --vault-id ./pass.sh -m setup
```

посмотреть расширенный лог

```bash
  ansible-playbook -i normal --vault-id ./pass.sh create-cl.yml -t init -l dc1-anac5-n1 -vvv
```
