#!/bin/bash
###### стопаем сервисы
#/usr/local/pf/bin/pfcmd service pf stop
#systemctl stop packetfence-config
#systemctl stop docker

# если нужно поставить определенную версию
# VERSION="112.1.1+20250322134222+155788+0011+devel+bullseye1"

###### делаем репку с текущими пакетами
if [ ! -e "/srv/anac-repo" ]; then
	echo "create/update local repo"
else
	mkdir -p /srv/anac-repo
	cd /srv/anac-repo || exit
	rm -f ./*.deb Packages Release
	for deb in $(apt list axelnac* -a | grep "$VERSION" | awk -F'/' '{print $1}' | egrep -v "test|dbgsym"); do
		apt download "${deb}=$VERSION"
	done
	apt download mariadb-backup fingerbank freeradius-common inotify-tools libinotifytools0 galera-4

	# Generate the Packages file
	dpkg-scanpackages . /dev/null >Packages
	gzip --keep --force -9 Packages

	# Generate the Release file
	echo 'Origin: anac-repo
Label: anac-repo
Codename: anac
Architectures: amd64
Components: main
Description: AxelNAC APT repository
SignWith: 12345ABC' >Release
	# The Date: field has the same format as the Debian package changelog entries,
	# that is, RFC 2822 with time zone +0000
	echo -e "Date: $(LANG=C date -Ru)" >>Release
	# Release must contain MD5 sums of all repository files (in a simple repo just the Packages and Packages.gz files)
	echo -e 'MD5Sum:' >>Release
	printf ' '$(md5sum Packages.gz | cut --delimiter=' ' --fields=1)' %16d Packages.gz' $(wc --bytes Packages.gz | cut --delimiter=' ' --fields=1) >>Release
	printf '\n '$(md5sum Packages | cut --delimiter=' ' --fields=1)' %16d Packages' $(wc --bytes Packages | cut --delimiter=' ' --fields=1) >>Release
	# Release must contain SHA256 sums of all repository files (in a simple repo just the Packages and Packages.gz files)
	echo -e '\nSHA256:' >>Release
	printf ' '$(sha256sum Packages.gz | cut --delimiter=' ' --fields=1)' %16d Packages.gz' $(wc --bytes Packages.gz | cut --delimiter=' ' --fields=1) >>Release
	printf '\n '$(sha256sum Packages | cut --delimiter=' ' --fields=1)' %16d Packages' $(wc --bytes Packages | cut --delimiter=' ' --fields=1) >>Release

	# Clearsign the Release file (that is, sign it without encrypting it)
	gpg --clearsign --digest-algo SHA512 --local-user "$USER" -o InRelease Release
	# Release.gpg only need for older apt versions
	# gpg -abs --digest-algo SHA512 --local-user $USER -o Release.gpg Release

fi
cd ../
###### докачиваем базовые образы
TAG_OR_BRANCH_NAME="$(cat /usr/local/pf/conf/build_id | egrep '^TAG_OR_BRANCH_NAME=' | awk -F'=' '{print $2}')"
for img in pfbuild-debian-bullseye pfdebian radiusd; do
	docker pull "10.31.202.12/$img:$TAG_OR_BRANCH_NAME"
	docker tag "10.31.202.12/$img:$TAG_OR_BRANCH_NAME" axelnac/"$img:$TAG_OR_BRANCH_NAME"
done

###### тарим образы
echo "!!! ВНИМАНИЕ, ПАКУЕТСЯ БОЛЬШОЙ ОБЪЕМ - ПРИДЕТСЯ ПОДОЖДАТЬ ~30мин"

docker save $(docker images -q) | pv | gzip --keep --force -6 >anac.tar.gz

###### делаем список тегов
docker images | sed '1d' | awk '{print $1 " " $2 " " $3}' >anac-img.list
###### копируем TAG_OR_BRANCH_NAME
cp /usr/local/pf/conf/build_id ./
###### тянем ФБ (или локально забрать можно )
wget http://10.31.202.12:8081/repository/anac-raw/fb-db/fingerbank.tgz

###### сваливаем все в кучу и топчем ногами
tar -cvf /tmp/docker-anac-update.tar /srv
echo "заливаем на nexus !!!"
curl -s -u ci-user:ci-user --upload-file /tmp/docker-anac-update.tar http://10.31.202.12:8081/repository/anac-raw/local-update/$(date +%F)/docker-anac-update.tar
