#!/bin/bash
source /etc/profile
export LOCAL_INSTALL='yes'
export DB_UPDATE='yes'
export DEBIAN_FRONTEND=noninteractive
export OVA_PWD=Y5upeAd9

# проверка доступного места
if (( 20000000 > $(df -P / | tail -n1 | awk '{print $4}') )); then
  echo "disk free size available < 20G !!!"
  exit 0
fi

if ip -br a | grep -q  "$(grep -A1 "CLUSTER in" /usr/local/pf/conf/cluster.conf | grep ip= | cut -d"=" -f2 | head -n1)";then
echo ">>> выполнится ТОЛЬКО на МАСТЕРЕ !!! (backup-and-maintenance.sh) <<<"
### резевируемм текущую инсталяцию, стандартный backup директории pf и базы
/usr/local/pf/addons/backup-and-maintenance.sh
### обновление схемы базы если есть переменная DB_UPDATE=yes
if [ $DB_UPDATE == "yes" ]; then
cat <<EOF | mysql pf
-- заглушка. пропишите необходимые дополнительные запросы
select 1;
EOF
fi
fi

### backup docker images
if [ ! -e "/srv/backup_old_img" ]; then
    mkdir -p /srv/backup_old_img
else
    rm -f /srv/backup_old_img/*
fi
docker save $(docker images -q) -o backup_old_img/anac.tar
### делаем список тегов
docker images | sed '1d' | awk '{print $1 " " $2 " " $3}' >backup_old_img/anac-img.list

##### хитрый шаг для кластера, чтобы он не наклал кучу логов после обновления
cp /usr/local/pf/conf/{cluster.conf,pf.conf,pfconfig.conf} /srv/backup_old_img/

#rm -rf /srv/anac-repo-old/
mv /srv/anac-repo /srv/anac-repo-old

### вкл режим обслуживания
/usr/local/pf/bin/cluster/maintenance --activate
systemctl disable packetfence-config
systemctl stop packetfence-config

### чистим docker
docker rm $(docker ps -q) -f
docker system prune -f
docker rmi $(docker images -q) -f

### распаковываем новую версию и ...
tar -xvf docker-anac-update.tar -C /
cd /srv

bash /srv/axelnac-install.sh noprompt

### возвращаем ноде память что она часть кластера
cp /srv/backup_old_img/*.conf /usr/local/pf/conf/
systemctl enable packetfence-config

# other task
apt -y reinstall freeradius-common
###tar -xvf /srv/fingerbank.tgz -C /usr/local/
##chown -R pf:fingerbank /usr/local/fingerbank/conf /usr/local/fingerbank/db 
# отключил и перенес в роль
#/usr/local/pf/bin/cluster/maintenance --deactivate
# /usr/local/pf/bin/pfcmd configreload hard